<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LigneCommande extends Model 
{

    protected $table = 'ligne_commande';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id', 'commande_id', 'produit_id', 'quantiter_produit', 'prix_unitaire');

    public function relationCommandes()
    {
        return $this->belongsTo('App\Models\Commande');
    }

    public function relationProduit()
    {
        return $this->belongsTo('App\Models\Produit');
    }

}